<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : dataexport.cgi
 * 
 *  Description: Data Export settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       28/06/14    v1.1 - custom server export
 * Akash Heimlich       22/10/15    v1.2 - data_sync service support
 *                      04/05/16    added more options for custom export
 *                      14/02/17    multiple lines, alerts
 * Akash Heimlich       09/07/18    WattmonOS 3
 *						20/03/21	Added 'static header' option and rearranged layout
 *                      15/04/21    Added 'debug' option and SSL for custom export
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DataExportCtrl"; 
$title=lang('PAGE_TITLE','dataexport');
include("/app/header.inc");
if ($_GET['clear_datalog']==1) {
    if ($_SERVER['HW_PLATFORM']>=20) {
        if (disk_status(0)==0) {
            unlink("0:/ini/datalog_status.ini");
        } else if (disk_status(2)==0) {
            unlink("2:/ini/datalog_status.ini");
        }
    } else unlink("/ini/datalog_status.ini");
}
$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20) {  // ULTRA
        $prefix=intval($_GLOBALS['log_drive']).':';
}

?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','dataexport')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('PAGE_TITLE','dataexport')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','dataexport')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','dataexport')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="testExport()" ng-disabled="form.$invalid" ><i class="icon-check"></i> <? print(lang('TEST_EXPORT','dataexport')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="testRouter()"  ><i class="icon-check"></i> <? print(lang('DETECT_ROUTER','dataexport')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="resetexport()"  ><i class="icon-trash"></i> <? print(lang('RESET_EXPORT','dataexport')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="log_export()"  ><i class="icon-check"></i> LOG AND EXPORT</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-click="export()"  ><i class="icon-check"></i> <? print(lang('EXPORT_NOW','dataexport')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1 || settings_locked' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','dataexport')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','dataexport')) ?>
    <? print(lang('HELP2','dataexport')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','dataexport')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>
<!-- VARIABLES -->
<? 
 $ini = ini_get_array("/config/dataexport.ini","export");
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="devicekey='<? print($ini['devicekey']); ?>';"></div><div ng-init="export_wattmon='<? print($ini['export_wattmon']); ?>';"></div>
<div ng-init="export_custom='<? print($ini['export_custom']); ?>';"></div>
<div ng-init="export_portal='<? print($ini['export_portal']); ?>';"></div>
<div ng-init="debug_custom_export='<? print($ini['debug_custom_export']); ?>';"></div>
<div ng-init="export_only='<? print(intval($ini['export_only'])); ?>';"></div>
<div ng-init="static_header='<? print(intval($ini['static_header'])); ?>';"></div>
<div ng-init="portal='<? print($ini['portal']!=''?$ini['portal']:"my.wattmon.com"); ?>';"></div>
<div ng-init="secure='<? print(intval($ini['secure'])); ?>';"></div>
<div ng-init="custom_url='<? print($ini['custom_url']); ?>';"></div>
<div ng-init="custom_lines=<? print(intval($ini['custom_lines'])>0?$ini['custom_lines']:15); ?>;"></div>
<div ng-init="export_lines=<? print(intval($ini['export_lines'])>0?$ini['export_lines']:15); ?>;"></div>
<div ng-init="alerts=<? print(intval($ini['alerts'])); ?>;"></div>

<div ng-init="noheader=<? print(intval($ini['noheader'])?$ini['noheader']:0); ?>;"></div>
<div ng-init="md5=<? print(intval($ini['md5'])?$ini['md5']:0); ?>;"></div>
<div ng-init="emonkey='<? print($ini['emonkey']); ?>';"></div><div ng-init="export_emoncms='<? print($ini['export_emoncms']); ?>';"></div>
<div ng-init="interval=<? print($ini['interval']); ?>;"></div>
<div ng-init="port=<? print($ini['port']); ?>;"></div>
<div ng-init="buffer_interval=<? print(intval($ini['buffer_interval'])); ?>;"></div>
<div ng-init="intervalcustom=<? print(intval($ini['intervalcustom'])); ?>;"></div>
<div ng-init="intervalemon=<? print($ini['intervalemon']); ?>;"></div>
<div ng-init="intervalportal=<? print($ini['intervalportal']); ?>;"></div>
<div ng-init="force_reboot=<? print($ini['force_reboot']); ?>;"></div>

<div ng-init="export_pvoutput='<? print($ini['export_pvoutput']); ?>';"></div><div ng-init="systemid='<? print($ini['systemid']); ?>';"></div><div ng-init="apikey='<? print($ini['apikey']); ?>';"></div>


<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('GLOBAL_SETTINGS','dataexport')) ?></h5>
        <p class="card-text">    
            
            <div class="form-group">
                <label for="force_reboot"><small class='text-muted'><? print(lang('FORCE_REBOOT','dataexport')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="force_reboot"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="force_reboot" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('FORCE_REBOOT_HELP','dataexport')) ?></small>
            </div>                  
        </p>
	</div>
</div> 
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('CLOUD_SETTINGS','dataexport')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="export_portal"><small class='text-muted'><? print(lang('EXPORT_STATUS','dataexport')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_portal"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_portal" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('EXPORT_STATUS_HELP','dataexport')) ?></small>
            </div>  
            <div class="form-group">
                <label for="portal"><? print(lang('SELECT_SERVER','dataexport')) ?></label>
                <select ng-model="portal" name='portal' class="form-control">
			                <option value='my.wattmon.com'>my.wattmon.com</option>
                            <option value='mycloud.wattmon.com'>mycloud.wattmon.com</option>
                           	<option value='ems.wattmon.com'>ems.wattmon.com</option>
							<option value='beta.wattmon.com'>beta.wattmon.com</option>
                </select>
                <small class="form-text text-muted"><? print(lang('SELECT_SERVER_HELP','dataexport')) ?></small>
	        </div>       
            <div class="form-group">
                <label for="secure"><small class='text-muted'>Use Encryption (HTTPS)</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="secure"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="secure" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted">This will speed up the export process for devices with a large amount of data points</small>
            </div>   
	        
	        <div class="form-group">
                <label for="intervalportal"><? print(lang('EXPORT_INTERVAL','dataexport')) ?></label>
                <input class="form-control" type='number' ng-model="intervalportal"  class='span12' name='port' integer required min=1 max=30 aria-describedby="rHelp" placeholder="<? print(lang('EXPORT_INTERVAL','dataexport')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('EXPORT_INTERVAL_HELP','dataexport')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.intervalportal.$invalid"><? print(lang('EXPORT_INTERVAL_INVALID','dataexport')) ?></small>
            </div>
            <div class="form-group">
                <label for="md5"><small class='text-muted'><? print(lang('MD5','dataexport')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="md5"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="md5" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('MD5_HELP','dataexport')) ?></small>
            </div>  
            <div class="form-group">
                <label for="export_lines"><? print(lang('EXPORT_LINES','dataexport')) ?></label>
                <input class="form-control" type='number' ng-model="export_lines"  class='span12' name='export_lines' integer required min=1 max="<?
			            if ($_SERVER['HW_PLATFORM']<10) print("15"); else print("200");
			            ?>" aria-describedby="rHelp" placeholder="<? print(lang('EXPORT_LINES','dataexport')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('EXPORT_LINES_HELP','dataexport')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.export_lines.$invalid"><? print(lang('EXPORT_LINES_INVALID','dataexport')) ?></small>
            </div>
            <div class="form-group">
                <label for="static_header"><small class='text-muted'>Use Static Header</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="static_header"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="static_header" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted">This will speed up the export process for devices with a large amount of data points</small>
            </div>   
		    <div class="form-group">
                <label for="alerts"><small class='text-muted'><? print(lang('ALERTS','dataexport')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="alerts"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="alerts" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('ALERTS_HELP','dataexport')) ?></small>
            </div>       
            <div class="form-group">
                <label for="export_only"><small class='text-muted'><? print(lang('EXPORT_ONLY','dataexport')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_only"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_only" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('EXPORT_ONLY_HELP','dataexport')) ?></small>
            </div>      
            <div class="form-group">
                <label for="buffer_interval"><? print(lang('BUFFER_INTERVAL','dataexport')) ?></label>
                <input class="form-control" type='number' ng-model="buffer_interval"  class='span12' name='buffer_interval' integer required min=0 max="360" aria-describedby="rHelp" placeholder="<? print(lang('BUFFER_INTERVAL','dataexport')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('BUFFER_INTERVAL_HELP','dataexport')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.buffer_interval.$invalid"><? print(lang('BUFFER_INTERVAL_INVALID','dataexport')) ?></small>
            </div>   		    
            <div class="card-footer bg-transparent border-success"><label class="control-label" for='export_lines'>Current Status</label><br>
            
			            <? print(lang('LAST_EXPORTED','dataexport')) ?> <? print(strftime("%c",ini_get($prefix."/ini/datalog_status.ini","status","last_export",0))); ?>. <br>
			            <? print(lang('FILE_POSITION','dataexport')) ?>: <? print(ini_get($prefix."/ini/datalog_status.ini","status","filepos",0)); ?><br>
			            <? print(lang('FILE_DATE','dataexport')) ?>: <? $file=ini_get($prefix."/ini/datalog_status.ini","status","file","");
			            
			            if ($file) {
			                if ($ini['export_only']) 
			                    print($file);
			                else
			                        print(substr($file,6,2)."/".substr($file,4,2)."/".substr($file,0,4)); 
			            } ?>
		    </div>
        </p>			                       
	</div>
</div> 

<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('CUSTOM_SETTINGS','dataexport')) ?></h5>
        <p class="card-text">    
            <div class="box-content" ng-show='export_only==1'>
    		    You have disabled CSV data logging using the Only store CSV data when exporting fails (for buffering) in <i>Local Storage</i> above.  Disable this to enabled custom data export.
    		</div>
    		<div class="box-content" ng-show='export_only==0'>
                <div class="form-group">
                    <label for="export_custom"><small class='text-muted'><? print(lang('CUSTOM_STATUS','dataexport')) ?></small></label>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" ng-model="export_custom"value="0">
                      <label class="form-check-label">
                        &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                      </label>
                    </div>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" ng-model="export_custom" value="1">
                      <label class="form-check-label" >
                        &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                      </label>
                    </div>  
                    <small id="ddHelp" class="form-text text-muted"><? print(lang('CUSTOM_STATUS_HELP','dataexport')) ?></small>
                </div>  
            
                <div class="form-group">
                    <label for="custom_url"><? print(lang('URL','dataexport')) ?></label>
                    <input type="text" class="form-control" ng-model="custom_url"  class='span12' ng-maxlength=128 name='custom_url'  aria-describedby="rnHelp" placeholder="<? print(lang('URL','dataexport')) ?>">
                    <small id="rnHelp" class="form-text text-muted"><? print(lang('URL_HELP','dataexport')) ?></small>
                </div>	  
		       
		       <div class="form-group">
                    <label for="intervalcustom"><? print(lang('CUSTOM_INTERVAL','dataexport')) ?></label>
                    <input class="form-control" type='number' ng-model="intervalcustom"  class='span12' name='intervalcustom' integer required min=1 max=30 aria-describedby="rHelp" placeholder="<? print(lang('CUSTOM_INTERVAL','dataexport')) ?>">
                    <small id="rHelp" class="form-text text-muted"><? print(lang('CUSTOM_INTERVAL_HELP','dataexport')) ?></small>
                    <small ng-cloak class='text-danger' ng-show="form.intervalcustom.$invalid"><? print(lang('CUSTOM_INTERVAL_INVALID','dataexport')) ?></small>
                </div>
                <div class="form-group">
                    <label for="custom_lines"><? print(lang('EXPORT_LINES','dataexport')) ?></label>
                    <input class="form-control" type='number' ng-model="custom_lines"  class='span12' name='custom_lines' integer required min=1 max="<?
    			            if ($_SERVER['HW_PLATFORM']<10) print("15"); else print("200");
    			            ?>" aria-describedby="rHelp" placeholder="<? print(lang('EXPORT_LINES','dataexport')) ?>">
                    <small id="rHelp" class="form-text text-muted"><? print(lang('EXPORT_LINES_HELP','dataexport')) ?></small>
                    <small ng-cloak class='text-danger' ng-show="form.custom_lines.$invalid"><? print(lang('EXPORT_LINES_INVALID','dataexport')) ?></small>
                </div>                
		       <div class="form-group">
                    <label for="noheader"><small class='text-muted'><? print(lang('HEADER','dataexport')) ?></small></label>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" ng-model="noheader"value="0">
                      <label class="form-check-label">
                        &nbsp;<? print(lang('INCLUDE','dataexport')) ?>
                      </label>
                    </div>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" ng-model="noheader" value="1">
                      <label class="form-check-label" >
                        &nbsp;<? print(lang('EXCLUDE','dataexport')) ?>
                      </label>
                    </div>  
                    <small id="ddHelp" class="form-text text-muted"><? print(lang('HEADER_HELP','dataexport')) ?></small>
                </div>  
                <div class="form-group">
                    <label for="debug_custom_export"><small class='text-muted'>Debug</small></label>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" ng-model="debug_custom_export"value="0">
                      <label class="form-check-label">
                        &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                      </label>
                    </div>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" ng-model="debug_custom_export" value="1">
                      <label class="form-check-label" >
                        &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                      </label>
                    </div>  
                    <small id="ddHelp" class="form-text text-muted">Add debug information into /logs/debug.txt to troubleshoot issues</small>
                </div>
   		        <div class="card-footer bg-transparent border-success"><label class="control-label" for='export_lines'><? print(lang('CURRENT_STATUS','dataexport')) ?></label><br>
			            <? print(lang('LAST_EXPORTED','dataexport')) ?> <? print(strftime("%c",ini_get($prefix."/ini/datalog_status.ini","custom","last_export",0))); ?>. <br>
			            <? print(lang('FILE_POSITION','dataexport')) ?>: <? print(ini_get($prefix."/ini/datalog_status.ini","custom","filepos",0)); ?><br>
			            <? print(lang('FILE_DATE','dataexport')) ?>: <? $file=ini_get($prefix."/ini/datalog_status.ini","custom","file","");
			            if ($file)
			                        print(substr($file,6,2)."/".substr($file,4,2)."/".substr($file,0,4)); ?>
			            
		        </div>	
		    </div>
		</p>
	</div>
</div> 	
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Export To PV Output</h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="export_pvoutput"><small class='text-muted'>Export data to PVOutput</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_pvoutput"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_pvoutput" value="1">
                  <label class="form-check-label" >
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted">Export data to PVOutput.org</small>
            </div>  
                    
	         <div class="form-group">
                    <label for="systemid">System ID</label>
                    <input type="text" class="form-control" ng-model="systemid"  class='span12' ng-maxlength=128 name='systemid'  aria-describedby="rnHelp" placeholder="SystemID">
                    <small id="rnHelp" class="form-text text-muted">Enter PVOutput System ID</small>
                </div>	  	
	         <div class="form-group">
                    <label for="apikey">API Key</label>
                    <input type="text" class="form-control" ng-model="apikey"  class='span12' ng-maxlength=128 name='apikey'  aria-describedby="rnHelp" placeholder="apikey">
                    <small id="rnHelp" class="form-text text-muted">API Key obtained from pvoutput.org</small>
                </div>	  	
        	</p>
	</div>
</div> 
<br/>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('REACHABILITY','dataexport')) ?></h5>
        <p class="card-text">    
            <? $networkstatus=ini_get("/config/network.ini","network","dhcp_enabled",0); 
                if ($networkstatus==1) {
                    ?><div class='alert alert-warning'><strong>Warning: </strong>DHCP is enabled, and therefore remote access to this Wattmon will most likely not be possible. <a href='/app/network.ini'>Edit Settings</a></div><?
                } ?>
            Data export to wattmon.com allows you to reach your device without the need for a static IP address or a DynDNS entry.  Wattmon will send your current IP
            address to the server every X minutes.  If you are using a USB cellular dongle, your device should be directly accessible.  If you are connected to a DSL modem
            or other router, you will need to set up port forwarding in order to reach Wattmon from an external network.  To find out how to do this, refer to the <a target='_blank' href="http://wattmon.com/resources/downloads/category/3-documentation?download=36:wattmon-installation-manual">user manual
            online</a>.<br>
            <br>
            Once this is configured, you will be able to access your device from this external link:<br><strong><a target='_blank' href='http://www.wattmon.com/live?key={{devicekey}}'>http://www.wattmon.com/live?key={{devicekey}}</a></strong><br>
            {{testresult}}
            
            <div class="form-group">
                <label for="export_wattmon"><small class='text-muted'><? print(lang('STATUS','dataexport')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_wattmon" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('DISABLED','dataexport')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="export_wattmon" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('ENABLED','dataexport')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','dataexport')) ?></small>
            </div>       
    
            <div class="form-group">
                <label for="devicekey"><? print(lang('DEVICE_KEY','dataexport')) ?></label>
                <input type="text" class="form-control" ng-model="devicekey"  class='span12' ng-maxlength=30 name='devicekey' readonly aria-describedby="rnHelp" my-directive placeholder="<? print(lang('DEVICE_KEY','dataexport')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('DEVICE_KEY_HELP','dataexport')) ?></small>
            </div>	               
		        
		    <div class="form-group">
                <label for="port"><? print(lang('ROUTER_PORT','dataexport')) ?></label>
                <input class="form-control" type='number' ng-model="port"  class='span12' name='port' integer required min=10 max=60000 aria-describedby="rHelp" placeholder="<? print(lang('ROUTER_PORT','http')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('ROUTER_PORT_HELP','dataexport')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.port.$invalid"><? print(lang('ROUTER_PORT_INVALID','dataexport')) ?></small>
            </div>        
            
            <div class="form-group">
                <label for="interval"><? print(lang('LIVE_INTERVAL','dataexport')) ?></label>
                <input class="form-control" type='number' ng-model="interval"  class='span12' name='port' integer required min=1 max=1000 aria-describedby="rHelp" placeholder="<? print(lang('LIVE_INTERVAL','dataexport')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('LIVE_INTERVAL_HELP','dataexport')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.interval.$invalid"><? print(lang('LIVE_INTERVAL_INVALID','dataexport')) ?></small>
            </div>
		</p>
	</div>
</div> 
<br/>
</form>

 <script>
     var app = angular.module('myApp', []);
     app.config(['$httpProvider', function($httpProvider) {
    delete $httpProvider.defaults.headers.common["X-Requested-With"];
}]);
     function DataExportCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
       $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.export=function() {
        window.open("/scripts/ip.cgi","_blank");
   }
   $scope.log_export=function() {
        window.open("/scripts/ip.cgi?lognow=1","_blank");
   }
   
   $scope.resetexport=function() {
        if (confirm("This will clear the datalog_status file, and exporting of any previous data will be aborted (for all export sections).  Data will start exporting from now. Continue?")) {
            document.location=document.location.href+"?clear_datalog=1";
        }
   }
   
   $scope.testExport=function() {
     var url = "/app/fwtest.cgi?devicekey="+$scope.devicekey+"&port="+$scope.port+"&callback=JSON_CALLBACK";
    $scope.errormsg="";
    $scope.successmsg="";
    $http.get(url)
        .then(function (response) {
          var data = response.data;      
          //$scope.successmsg=(data.status==1)?"Saved Settings":"";
          $scope.errormsg=data.error;
          $scope.successmsg=data.success;
          return data;
        }, function(reason) {
            $scope.errormsg="Error";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
   $scope.testRouter=function() {
     var url = "/app/fwdetect.cgi";
    $scope.errormsg="";
    $scope.successmsg="";
    
    $http.get(url)
        .then(function (response) {
          var data = response.data;      
          $scope.errormsg=data.error;
          $scope.successmsg=data.success;
          return data;
        }, function(reason) {
            $scope.errormsg="Error";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
   $scope.saveSettings=function () {
        if ($scope.form.$invalid) {
            $scope.errormsg="<? print(lang('FORM_INVALID','actionedit')) ?>";
            return;
        }
        $scope.loading=1;
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       //alert();
       //
       $http.post('/app/configsave.cgi?config=dataexport.ini&section=export',
       "export_wattmon="+$scope.export_wattmon+
       "&devicekey="+$scope.devicekey+
       "&interval="+$scope.interval+
       "&port="+$scope.port+
       "&export_portal="+$scope.export_portal+
       "&portal="+$scope.portal+
       "&export_emoncms="+$scope.export_emoncms+
       "&emonkey="+$scope.emonkey+
       "&intervalemon="+$scope.intervalemon+
       "&export_only="+$scope.export_only+
       "&static_header="+$scope.static_header+
       "&secure="+$scope.secure+
        "&export_pvoutput="+$scope.export_pvoutput+
        "&intervalportal="+$scope.intervalportal+
        "&systemid="+$scope.systemid+
        "&apikey="+$scope.apikey+
        "&export_custom="+$scope.export_custom+
        "&custom_url="+$scope.custom_url+
        "&intervalcustom="+$scope.intervalcustom+
        "&custom_lines="+$scope.custom_lines+
        "&export_lines="+$scope.export_lines+
        "&md5="+$scope.md5+
        "&noheader="+$scope.noheader+
        "&force_reboot="+$scope.force_reboot+
        "&buffer_interval="+$scope.buffer_interval+
        "&debug_custom_export="+$scope.debug_custom_export+
        "&alerts="+$scope.alerts)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          $scope.loading=0;
          return data;
        }, function(reason) {
            $scope.loading=0;
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>




