<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : actions.cgi
 * 
 *  Description: Action list page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       06/07/18    WattmonOS 3
 ********************************************************************/
/*

Actions have a valid time range (between 10 am and 4 pm)
Actions Types:
    1 - Switch On a device
    2 - Switch Off a device
    3 - Send an email
    4 - Set a global variable
    
Example:
Action Name: Fridge Control
Action Type: 1 Switch On Device By Role
Device Role Id: (11) Output 1
Active Time Start: 10:00
Active Time End: 12:00
Conditions: ALL, or ANY
Num Conditions: 2
Condition 1: 
  Preset Var 1 (Solar Current)
  Condition: < 
  Value: 10
Condition 2:
  Preset Var 8 (Battery Percent)
  Condition: <
  Value: 50
  
Actions:
Trigger types:
1 - Preset Variable
2 - role value
3 - Global Variable

Preset Variables:
1 - Solar Current
2 - Solar Wattage
3 - Grid Charge Current
4 - Grid Charge Wattage
5 - Grid Load Current
6 - Grid Load Wattage
7 - Battery Voltage
8 - Battery Charge Percent
9 - Solar kwH today
10 - Grid kWh today
*/
include("/app/config.inc");
$angular_controller="ActionCtrl"; 
$title='Actions';
include("/app/header.inc");
?>

<style>
    /* GLOBAL STYLES
    -------------------------------------------------- */
table {
    font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
}
    
.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','actions')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-sitemap"></i> <? print(lang('PAGE_TITLE','actions')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','actions')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="btn btn-primary" onclick="window.open('/app/action_report.cgi','_blank','');"><i class="icon-briefcase"></i>
    <? print(lang('REPORT','actions')) ?>
  </a>
  </li>

  <li class="nav-item">
    <a class="btn btn-primary" ng-click="addAction()"><i class="icon-plus"></i>
    <? print(lang('ADD_ROLE','actions')) ?>
  </a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','actions')) ?>
  <? print(lang('HELP2','actions')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!-- VARIABLES -->
        
<div class='clearfix'></div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ACTIONS','actions')) ?></h5>
        <p class="card-text">   
            <div class="table-responsive">					
                <table class='table table-striped'>
                    <tr>
                        <th scope="col"><a href="" ng-click="predicate = ''; reverse=!reverse">ID</a></th>
                        <th scope="col"><a href="" ng-click="predicate = 'name'; reverse=!reverse"><? print(lang('ACTION','actions')) ?></th></th>
                        <th scope="col"><a href="" ng-click="predicate = 'status'; reverse=!reverse"><? print(lang('STATUS','actions')) ?></th>
                        <th scope="col"><a href="" ng-click="predicate = 'start'; reverse=!reverse"><? print(lang('TIME','actions')) ?></th>
                        <th scope="col"><? print(lang('OPTIONS','actions')) ?></th>
                    </tr>
                    <tr ng-repeat="item in actions | orderBy:predicate:reverse" ng-show='item.status<10' class="enabled{{item.status}}">
                        <td><span class="badge badge-pill badge-dark">{{item.id}}</span></td>
                        <td><strong>{{item.name}}</strong></td>
                        <td><div ng-show='item.status>0' class="label label-success">{{isActive(item)}}</div><div ng-show='item.status==0' class="label label-failure">{{isActive(item)}}</div></td>
                        <td><span ng-show="item.status>1">{{makeTime(item)}}</span></td>
                        <td>
                            <div ng-hide="refresh" class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <? print(lang('ACTION','devices')) ?> <span class="caret"></span>
                                </button>
                        
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a class="dropdown-item" ng-click='edit(item.id)' href='#'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','actions')) ?></a>
                                    <a class="dropdown-item" ng-show='item.status>0' ng-click='dis(item.id)' href='#'><i class="icon-check-empty"></i>&nbsp;<? print(lang('DISABLE','actions')) ?></a>
                                    <a class="dropdown-item" ng-click='del(item.id)' href='#'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','actions')) ?></a>
                                </div>
                            </div>
                        </td>
                    </tr>
                </table>
			</div>
		</p>
	</div>
</div>  

         
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><? print(lang('CANCEL','roles')) ?></button>
        <button type="button" class="btn btn-primary" ng-click="doModal()"><? print(lang('CONTINUE','roles')) ?></button>
      </div>
    </div>
  </div>
</div>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http) {
  
  this.async = function() {
    return $http.get('/app/action_ajax.cgi?action=list')
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        //alert('Failed: ' + reason);
        //$timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});


function ActionCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  var pc=100;
  $scope.scanning=0;
  $scope.refresh=0;
$scope.helpvisible=0;
$scope.items=[];
$scope.predicate = 'name';
$scope.asyncData = dataService.async();
 $scope.poll=function(){
      $scope.asyncData = dataService.async();
     
    };
  $scope.edit=function(idx) {
    document.location="/app/actionedit.cgi?action_idx="+idx;
  }
  
  $scope.addAction=function() {
    document.location="/app/actionedit.cgi?new=1";
  }
  $scope.del=function(idx) {
    $scope.selectedIdx=idx;
    $scope.action=2;
    $scope.question="Delete this action?";
    $('#myModal').modal('show');
  }
  $scope.dis=function(idx) {
    $scope.selectedIdx=idx;
    $scope.action=1;
    $scope.question="Disable this action?";
    $('#myModal').modal('show');
  }
  $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  
  $scope.doModal=function() {
      if ($scope.action==1) {
          $scope.disDevice();
      } else if ($scope.action==2) {
          $scope.delDevice();
      } else {
        document.location="/app/devicecalib.cgi?device_idx="+$scope.selectedIdx;
      }
  }
  $scope.disDevice=function() {
    $('#myModal').modal('hide');
    $scope.errormsg="";
    $scope.successmsg="";
      
     $http.get('/app/action_ajax.cgi?action=disable&action_idx='+$scope.selectedIdx) 
    .then(function (response) {
        if (response.data.status==0) {
            $scope.errormsg="There was an error disabling the action.";
        } else $scope.successmsg="Action disabled successfully";
        
      $scope.poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
  }
  $scope.delDevice=function() {
    $('#myModal').modal('hide');
    $scope.errormsg="";
    $scope.successmsg="";
      
     $http.get('/app/action_ajax.cgi?action=delete&action_idx='+$scope.selectedIdx) 
    .then(function (response) {
        if (response.data.status==0) {
            $scope.errormsg="There was an error deleting the action.";
        } else $scope.successmsg="Action deleted successfully";
        
      $scope.poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
  }
  $scope.isActive=function(item) {
      if (item.status==0) 
        return "Disabled";
      if (item.status==1) 
        return "Always Active";
      if (item.status==2) 
        return "Active between time";
      if (item.status==3) 
        return "Disabled between time";
      if (item.status==4) 
        return "Execute at time";
      if (item.status==5) 
        return "Manually triggered";
      if (item.status==6) 
        return "Execute at interval";
        
        
  }
  $scope.makeTime=function(item) {
    if ((item.status==2) || (item.status==3)) 
        return item.start+"-"+item.end;
    if ((item.status==4))
        return item.start;
    return "";
  }
  $scope.isDisabled=function(item) {
      if (item.status==0) return 1;
      return 0;
  }
  $scope.isError=function(item) {
      if (item.status!=0 && item.last_response>=2) return 1;
      return 0;
  }
  $scope.lastAccess=function(item) {
      if (item.last_response<2)
        return "Active";
      return "Last access "+item.last_response+"s ago";
  }
  
  $scope.$watch('refresh', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('scanning', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('asyncData', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        $scope.connectstatus=asyncData.loggedin?"loggedin":"loggedout";
        $scope.actions = asyncData.actions;
        
        pc=0;
    }
  });
  

}
</script>    
<? include("/app/footer.inc"); ?>
