<?
max_execution_time(30);
/*
scom.exe --port=COM4 --verbose=3 read_property src_addr=1 dst_addr=101 object_type=1 object_id=3000 property_id=5 format=INT32
*/
// studer device simulator
function header_checksum($data,$start,$len) {
    $A = 0xFF;
    $B = 0;
    for ($I = 0;$i<$len;$i++) {
        $A = ($A + $data[$start+$i]) % 0x100;
        $B = ($B + $A) % 0x100;
    }
    return ($A + $B<<8);
}

//$s=fseropen(38400,0,0,1); // even parity
$s=fseropen(115200,0,0,0); // even parity
if ($_GLOBALS['studer_custom_get']) {
    if (filesize($s)) 
            $st=fread($s,filesize($s));
    send_packet($_GLOBALS['studer_custom_id'],$_GLOBALS['studer_custom_prop'],$_GLOBALS['studer_custom_object']);
    $_GLOBALS['studer_custom_response']=read_packet();
    $_GLOBALS['studer_custom_get']=0;
}


for ($i=0;$i<$_GLOBALS['studer_count'];$i++) {
    // if this is an inveter
    if ($_GLOBALS['studer'.$i.'id']<300) {
        $objects=array();//,3125,3126,3127,3128,3129);
        $objects[]=3000; //battery voltage
        $objects[]=3005; //battery charge current
        $objects[]=3007; //battery SOC
        $objects[]=3010; //battery stage
        $objects[]=3011; //input voltage
        $objects[]=3013; //input power
        $objects[]=3021; //output voltage
        $objects[]=3022; //output voltage
        $objects[]=3023; //output power
        $objects[]=3049; //State
        $objects[]=3028; //system state
        $objects[]=3085; //output freq
        $objects[]=3087; //output active power
        $objects[]=3081; //energy current day
        $objects[]=3088; //input active power
        $objects[]=3096; //output active power (minute avg)
        $objects[]=3136; //input active power
    } else {  // if this is a VarioTrack
        $objects=array();
        $objects[]=11000; //battery voltage
        $objects[]=11001; //battery current
        $objects[]=11002; //PV Voltage
        $objects[]=11004; //PV Power
        $objects[]=11007; //kwh today
        $objects[]=11011; //kwh yesterday
        $objects[]=11019; //max kw today
        $objects[]=11016; //enum operating mode
        $objects[]=11034; //enum operating mode
    }
  //for ($cnt=0;$cnt<sizeof($objects);$cnt++) {
    
      if (filesize($s)) 
            $st=fread($s,filesize($s));
            
            $prop=6;
            $obj=$objects[$_GLOBALS['studer'.$i.'cur_idx']];
            // special enum objects
            if ($obj==11016) $prop=3;
            if ($obj==11034) $prop=3; // error type
            if ($obj==3010) $prop=3;
            if ($obj==3049) $prop=3;
            send_packet($_GLOBALS['studer'.$i.'id'],$prop,$objects[$_GLOBALS['studer'.$i.'cur_idx']]);
              $_GLOBALS['studer'.$i.'cur_idx']++;
                if ($_GLOBALS['studer'.$i.'cur_idx']>=sizeof($objects)) $_GLOBALS['studer'.$i.'cur_idx']=0;
            $packet=read_packet();
            
            //if ($packet['property_id']==6) {
                if ($packet['object_id']==1138) $_GLOBALS['studer'.$i.'max_charge_current']=$packet['val'];
                if ($packet['object_id']==3000) $_GLOBALS['studer'.$i.'bat_voltage']=$packet['val'];
                if ($packet['object_id']==3005) $_GLOBALS['studer'.$i.'charge_current']=$packet['val'];
                if ($packet['object_id']==3007) $_GLOBALS['studer'.$i.'bat_percent']=$packet['val'];
                if ($packet['object_id']==3010) $_GLOBALS['studer'.$i.'bat_stage']=$packet['val'];
                if ($packet['object_id']==3011) $_GLOBALS['studer'.$i.'v_input']=$packet['val'];
                if ($packet['object_id']==3013) $_GLOBALS['studer'.$i.'p_input']=$packet['val'];
                if ($packet['object_id']==3021) $_GLOBALS['studer'.$i.'v_output']=$packet['val'];
                if ($packet['object_id']==3022) $_GLOBALS['studer'.$i.'a_output']=$packet['val'];
                if ($packet['object_id']==3023) $_GLOBALS['studer'.$i.'p_output']=$packet['val'];
                if ($packet['object_id']==3028) $_GLOBALS['studer'.$i.'mode']=$packet['val'];
                if ($packet['object_id']==3049) $_GLOBALS['studer'.$i.'state']=$packet['val'];
                if ($packet['object_id']==3081) $_GLOBALS['studer'.$i.'kwh_today']=$packet['val'];
                if ($packet['object_id']==3085) $_GLOBALS['studer'.$i.'frequency']=$packet['val'];
                if ($packet['object_id']==3087) $_GLOBALS['studer'.$i.'output_power']=$packet['val'];
                if ($packet['object_id']==3088) $_GLOBALS['studer'.$i.'input_power']=$packet['val'];
                if ($packet['object_id']==3096) $_GLOBALS['studer'.$i.'output_power_avg']=$packet['val'];
                if ($packet['object_id']==3136) $_GLOBALS['studer'.$i.'output_kwh']=$packet['val'];
                if ($packet['object_id']==11000) $_GLOBALS['studer'.$i.'bat_voltage']=$packet['val'];
                if ($packet['object_id']==11001) $_GLOBALS['studer'.$i.'bat_current']=$packet['val'];
                if ($packet['object_id']==11002) $_GLOBALS['studer'.$i.'pv_voltage']=$packet['val'];
                if ($packet['object_id']==11004) $_GLOBALS['studer'.$i.'pv_power']=$packet['val'];
                if ($packet['object_id']==11007) $_GLOBALS['studer'.$i.'kwh_today']=$packet['val'];
                if ($packet['object_id']==11011) $_GLOBALS['studer'.$i.'kwh_yesterday']=$packet['val'];
                if ($packet['object_id']==11016) $_GLOBALS['studer'.$i.'mode']=$packet['val'];
                if ($packet['object_id']==11019) $_GLOBALS['studer'.$i.'max_kw_today']=$packet['val'];
                if ($packet['object_id']==11034) $_GLOBALS['studer'.$i.'error']=$packet['val'];
              
                
             //   print_r($packet);
            //}
    //}
}


//print_r($_GLOBALS['studer']);

function send_packet($dest,$property_type,$object) {    
    $inframe=0;
    global $s;
    $data=array();
    $len=0;
    $rxlen=0;
    $data=array(0xAA,00,01,00,00,00);
    // first inverter
    $data[]=$dest & 0xFF;
    $data[]=($dest >> 8) & 0xFF;
    $data[]=($dest >> 16) & 0xFF;
    $data[]=($dest >> 24) & 0xFF;
    
    
    $pktlen=10;
    $user_info=1;
    // length
    $data[]=$pktlen & 0xFF;
    $data[]=($pktlen>>8) & 0xFF; 
    
    $res=header_checksum($data,1,sizeof($data)-1);
    $data[]=$res & 0xFF;
    $data[]=($res>>8) & 0xFF; 
    //printf("%X",$res);
    $dataptr=sizeof($data);
    //$data[]=0x6f;
    //$data[]=0x71;
    
    //packet start
    $data[]=0x00;
    // read property
    $data[]=0x01;
    // USER_INFO
    $data[]=0x01;
    $data[]=0x00;
    
    
    $data[]=$object & 0xFF;
    $data[]=($object >> 8) & 0xFF;
    $data[]=($object >> 16) & 0xFF;
    $data[]=($object >> 24) & 0xFF;
    
    // property type
    $data[]=$property_type;
    $data[]=0x00;
    $res=header_checksum($data,$dataptr,$pktlen);
    $data[]=$res & 0xFF;
    $data[]=($res>>8) & 0xFF; 
    //$data[]=0xC5;
    //$data[]=0x90
//    print("Send: ");
    for ($i=0;$i<sizeof($data);$i++) {
       // printf("%02X ",$data[$i]);
        fwrite($s,$data[$i]);
    }
}
//die();
/*print("\r\nreceive: ");
$len=0;
while(1) {
    if (filesize($s)) {
        $len++;
        $st=fread($s,1);
        $ch=charat($st,0)&0xFF;
        printf("%02X ",$ch);
    }
    if ($len==26) break;
};
print("success");
die();*/
function read_packet() {
    $data=array();
    $resa=array();
    global $s;
    while (1) {
        
        if (filesize($s)) {
            $st=fread($s,1);
            $ch=charat($st,0)&0xFF;
            if (!$inframe) {
                if ($ch==0xAA) {
                    $inframe=1;
                    $rxlen=0;
                }
            }
            if ($inframe) {
                $data[]=$ch;
                $rxlen++;
                
                if ($rxlen>=14) {
                    if (!$len) {
                        $len=$data[10]+$data[11]*0x100;
                        $src_addr=$data[2]+$data[3]*0x100+$data[4]*0x10000+$data[5]*0x1000000;
                        $dst_addr=$data[6]+$data[7]*0x100+$data[8]*0x10000+$data[9]*0x1000000;
                        //print("Frame header received, len=".$len."\r\n");
                        $res=header_checksum(&$data,1,11);
                        //printf("CHECKSUM=%X\r\n",$res);
                        $cs=$data[12]+$data[13]*0x100;
                        if ($cs==$res) {
                          //  print("Header checksum OK!\r\n");
                            $header_ok=1;
                        } else {
                            printf("Header checksum failed - expected %X but got %X\r\n",$cs,$res);
                        }
                      //  print("SRC=".$src_addr."\r\n");
                        //print("DST=".$dst_addr."\r\n");
                    }
                    if ($rxlen==($len+16)) {  // full frame there
                        //print("Frame received fully\r\n");
                        //print("Frame type: ");
                        if ($data[15]==1) {
    //                        print("READ_PROPERTY\r\n");
                            $object_type=$data[16]+$data[17]*0x100;
                            //print("OBJECT TYPE: ".$object_type."\r\n");
                            $resa['object_type']=$object_type;
                            $object_id=$data[18]+$data[19]*0x100+$data[20]*0x10000+$data[21]*0x1000000;
                            //print("OBJECT ID: ".$object_id."\r\n");
                            $resa['object_id']=$object_id;
                            $property_id=$data[22]+$data[23]*0x100;
                            //print("PROPERTY ID: ".$property_id." ");
                            $resa['property_id']=$property_id;
                            if ($property_id==3) {
                                $value=$data[24]+$data[25];
                            } else {
                                if ($property_id>=5) {
                                    $value=$data[24]+$data[25]*0x100+$data[26]*0x10000+$data[27]*0x1000000;
                                }
                            }
                            if ($property_id==6)
                                $val=inttoieee754($value);
                            else $val=$value;
                            $resa['val']=$val;
                            //print("PROPERTY VALUE: ".$val."\r\n");
                            
                            /*
                            BOOL = 1
                            FORMAT = 2 : a property what define the format of an other property, 16 bit integer
    ENUM = 3 : a value that is part of a enumeration of possible values, represented with a 16 bit integer
    ERROR = 4 : 16 bit error code
    INT32 = 5 : 32 bit signed value
    FLOAT = 6 : float in 32 bit IEEE 754 format, little endian
    STRING = 7 : ISO_8859-15 string of 8 bit characters
    DYNAMIC = 8 : a property with a different format for each object id
    BYTE_STREAM = 9 : a stream a byte of abitrary length*/
    
                            /*if ($property_id==1) print(" (BOOL)\r\n");
                            if ($property_id==2) print(" (FORMAT 16 bit)\r\n");
                            if ($property_id==3) print(" (ENUM 16 bit)\r\n");
                            if ($property_id==4) print(" (ERROR 16 bit)\r\n");
                            if ($property_id==5) print(" (INT32)\r\n");
                            if ($property_id==6) print(" (FLOAT)\r\n");
                            if ($property_id==7) print(" (STRING)\r\n");
                            if ($property_id==8) print(" (DYNAMIC)\r\n");
                            if ($property_id==9) print(" (BYTESTREAM)\r\n");*/
                            $res=header_checksum(&$data,14,$len);
                            $cs=$data[$rxlen-2]+$data[$rxlen-1]*0x100;
                            if ($cs==$res) {
                             //   print("Data checksum OK!\r\n");
                                $data_ok=1;
                            } else {
                                printf("Data checksum failed - expected %X but got %X\r\n",$cs,$res);
                            }
                         //   printf("CHECKSUM=%X\r\n",$res);
                            break;
                        } else print($data[14]);
                        print("\r\n");
                        //for ($i=0;$i<$rxlen;$i++) printf("%02X ",$data[$i]);    
                        $inframe=0;
                        $data=array();
                        $len=0;
                      //  break;
                    }
                }
            }
            
        }
    }
    if ($data_ok) 
        return $resa;
    return 0;
}
// flush buffer
//if (filesize($s)) $st=fread($s,filesize($s));
//fclose($s);
?>

