<?
/**
 * @package EnergyMeterWidget
 * @author Akash Heimlich
 * @description This widget integrates with a 3-phase energy meter IC over SPI
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Studer_install($val) {
        Studer_enable();
        return 1;
    }
     
    function Studer_uninstall() {
        setPackageStatus("Studer",0);
        return 1;
    }
    
    function Studer_enable() {
        setPackageStatus("Studer",2);
        addWidget("/package/Studer.inc","Studer",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function Studer_disable() {
        setPackageStatus("Studer",3);
        addWidget("/package/Studer.inc","Studer",4,"icon-play",1,1); // disable
        return 1;
    }
    
function header_checksum($data,$start,$len) {
    $A = 0xFF;
    $B = 0;
    for ($I = 0;$i<$len;$i++) {
        $A = ($A + $data[$start+$i]) % 0x100;
        $B = ($B + $A) % 0x100;
    }
    return ($A + $B<<8);
}

function send_packet($dest,$property_type,$object) {    
    $inframe=0;
    global $s;
    $data=array();
    $len=0;
    $rxlen=0;
    $data=array(0xAA,00,01,00,00,00);
    // first inverter
    $data[]=$dest & 0xFF;
    $data[]=($dest >> 8) & 0xFF;
    $data[]=($dest >> 16) & 0xFF;
    $data[]=($dest >> 24) & 0xFF;
    
    
    $pktlen=10;
    $user_info=1;
    // length
    $data[]=$pktlen & 0xFF;
    $data[]=($pktlen>>8) & 0xFF; 
    
    $res=header_checksum($data,1,sizeof($data)-1);
    $data[]=$res & 0xFF;
    $data[]=($res>>8) & 0xFF; 
    //printf("%X",$res);
    $dataptr=sizeof($data);
    //$data[]=0x6f;
    //$data[]=0x71;
    
    //packet start
    $data[]=0x00;
    // read property
    $data[]=0x01;
    // USER_INFO
    $data[]=0x01;
    $data[]=0x00;
    
    
    $data[]=$object & 0xFF;
    $data[]=($object >> 8) & 0xFF;
    $data[]=($object >> 16) & 0xFF;
    $data[]=($object >> 24) & 0xFF;
    
    // property type
    $data[]=$property_type;
    $data[]=0x00;
    $res=header_checksum($data,$dataptr,$pktlen);
    $data[]=$res & 0xFF;
    $data[]=($res>>8) & 0xFF; 
    //$data[]=0xC5;
    //$data[]=0x90
//    print("Send: ");
    for ($i=0;$i<sizeof($data);$i++) {
       // printf("%02X ",$data[$i]);
        fwrite($s,$data[$i]);
    }
}

function read_packet() {
    $data=array();
    $resa=array();
    global $s;
    $timeout=microtime();
    while (1) {
        if ((microtime()-$timeout)>500) 
            break;
        if (filesize($s)) {
            $st=fread($s,1);
            $ch=charat($st,0)&0xFF;
            printf("Read: %X ",$ch);
            if (!$inframe) {
                if ($ch==0xAA) {
                    $inframe=1;
                    $rxlen=0;
                }
            }
            if ($inframe) {
                $data[]=$ch;
                $rxlen++;
                
                if ($rxlen>=14) {
                    if (!$len) {
                        $len=$data[10]+$data[11]*0x100;
                        $src_addr=$data[2]+$data[3]*0x100+$data[4]*0x10000+$data[5]*0x1000000;
                        $dst_addr=$data[6]+$data[7]*0x100+$data[8]*0x10000+$data[9]*0x1000000;
                        //print("Frame header received, len=".$len."\r\n");
                        $res=header_checksum(&$data,1,11);
                        //printf("CHECKSUM=%X\r\n",$res);
                        $cs=$data[12]+$data[13]*0x100;
                        if ($cs==$res) {
                          //  print("Header checksum OK!\r\n");
                            $header_ok=1;
                        } else {
                            printf("Header checksum failed - expected %X but got %X\r\n",$cs,$res);
                        }
      //                  print("SRC=".$src_addr."\r\n");
                        //print("DST=".$dst_addr."\r\n");
                    }
                    if ($rxlen==($len+16)) {  // full frame there
                        //print("Frame received fully\r\n");
                        //print("Frame type: ");
                        if ($data[15]==1) {
    //                        print("READ_PROPERTY\r\n");
                            $object_type=$data[16]+$data[17]*0x100;
                            //print("OBJECT TYPE: ".$object_type."\r\n");
                            $resa['object_type']=$object_type;
                            $object_id=$data[18]+$data[19]*0x100+$data[20]*0x10000+$data[21]*0x1000000;
                            //print("OBJECT ID: ".$object_id."\r\n");
                            $resa['object_id']=$object_id;
                            $property_id=$data[22]+$data[23]*0x100;
                            //print("PROPERTY ID: ".$property_id." ");
                            $resa['property_id']=$property_id;
                           if ($property_id==3) {
                                $value=$data[24]+$data[25];
                            } else { 
                                if ($property_id>=5) {
                                    $value=$data[24]+$data[25]*0x100+$data[26]*0x10000+$data[27]*0x1000000;
                                } else $value=$data[24];
                            }
                            if ($property_id==6)
                                $val=inttoieee754($value);
                            else $val=$value;
                            $resa['val']=$val;
                            //print("PROPERTY VALUE: ".$val."\r\n");
                            
                            /*
                            BOOL = 1
                            FORMAT = 2 : a property what define the format of an other property, 16 bit integer
    ENUM = 3 : a value that is part of a enumeration of possible values, represented with a 16 bit integer
    ERROR = 4 : 16 bit error code
    INT32 = 5 : 32 bit signed value
    FLOAT = 6 : float in 32 bit IEEE 754 format, little endian
    STRING = 7 : ISO_8859-15 string of 8 bit characters
    DYNAMIC = 8 : a property with a different format for each object id
    BYTE_STREAM = 9 : a stream a byte of abitrary length*/
    
                            /*if ($property_id==1) print(" (BOOL)\r\n");
                            if ($property_id==2) print(" (FORMAT 16 bit)\r\n");
                            if ($property_id==3) print(" (ENUM 16 bit)\r\n");
                            if ($property_id==4) print(" (ERROR 16 bit)\r\n");
                            if ($property_id==5) print(" (INT32)\r\n");
                            if ($property_id==6) print(" (FLOAT)\r\n");
                            if ($property_id==7) print(" (STRING)\r\n");
                            if ($property_id==8) print(" (DYNAMIC)\r\n");
                            if ($property_id==9) print(" (BYTESTREAM)\r\n");*/
                            $res=header_checksum(&$data,14,$len);
                            $cs=$data[$rxlen-2]+$data[$rxlen-1]*0x100;
                            if ($cs==$res) {
                           //     print("Data checksum OK!\r\n");
                                $data_ok=1;
                            } else {
                                printf("Data checksum failed - expected %X but got %X\r\n",$cs,$res);
                            }
                         //   printf("CHECKSUM=%X\r\n",$res);
                            break;
                        } else print($data[14]);
                        print("\r\n");
                        //for ($i=0;$i<$rxlen;$i++) printf("%02X ",$data[$i]);    
                        $inframe=0;
                        $data=array();
                        $len=0;
                      //  break;
                    }
                }
            }
            
        }
    }
    if ($data_ok) 
        return $resa;
    return 0;
}

    function Studer_ajax() {
        $_GLOBALS['studer_custom_id']=$_GET['device_id'];
        $_GLOBALS['studer_custom_prop']=$_GET['prop'];
        $_GLOBALS['studer_custom_object']=$_GET['object_id'];
        $_GLOBALS['studer_custom_get']=1;
        
        // wait for second script to finish off 
        while ($_GLOBALS['studer_custom_get']) {
            sleep(100);
        }
        print('{"status":1,"val":"'.$_GLOBALS['studer_custom_response']['val'].'","prop":"'.$_GLOBALS['studer_custom_response']['prop'].'"}');
    }
    $s=0;;

    /* this is called at system boot */
    function Studer_init() {
        global $s;
        //return 0;
        $_GLOBALS['studer']=array();
        $_GLOBALS['studer_count']=0;
        //$s=fseropen(38400,0,0,1); // even parity
        $s=fseropen(115200,0,0,0); // even parity
       // if (filesize($s)) $st=fread($s,filesize($s));
        $objects=array(3124);
        for ($dev=101;$dev<110;$dev++) {
        

                send_packet($dev,6,3124);  // get model
                //send_packet($dev,1,3000);  // get model
                $packet=read_packet();
                if ($packet['property_id']==6) {
                
                    if ($packet['val']==1) {
                        print("XTH Family at ".$dev."\r\n") ;
                        $_GLOBALS['studer'.$_GLOBALS['studer_count'].'family']="XTH Family";
                        $_GLOBALS['studer'.$_GLOBALS['studer_count'].'id']=$dev;
                        $_GLOBALS['studer_count']++;
                    }
                    if ($packet['val']==256) {
                            print("XTM Family at ".$dev."\r\n") ;
                            $_GLOBALS['studer'.$_GLOBALS['studer_count'].'family']="XTM Family";
                            $_GLOBALS['studer'.$_GLOBALS['studer_count'].'id']=$dev;
                            send_packet($dev,6,3125);
                            $packet=read_packet();
                            print("Power rating: ".$packet['val']."\r\n");
                            $_GLOBALS['studer'.$_GLOBALS['studer_count'].'rated_power']=$packet['val'];
                            send_packet($dev,6,3126);
                            $packet=read_packet();
                            print("Output voltage: ".$packet['val']."\r\n");
                            $_GLOBALS['studer'.$_GLOBALS['studer_count'].'rated_voltage']=$packet['val'];
                            send_packet($dev,6,3127);
                            $packet=read_packet();
                            print("Battery voltage: ".$packet['val']."\r\n");
                            $_GLOBALS['studer'.$_GLOBALS['studer_count'].'rated_bat_voltage']=$packet['val'];
                            $_GLOBALS['studer_count']++;
                    }  
                
                    if ($packet['val']==512) {
                        print("XTS Family at ".$dev."\r\n") ;
                        $_GLOBALS['studer'.$_GLOBALS['studer_count'].'family']="XTS Family";
                        $_GLOBALS['studer'.$_GLOBALS['studer_count'].'id']=$dev;
                        $_GLOBALS['studer_count']++;
                
                    } 
            
                }
                if (filesize($s)) $st=fread($s,filesize($s));
                send_packet($dev,3,11015);  // get VarioTrack model
                $packet=read_packet();
                if ($packet['property_id']==3) {
                    $_GLOBALS['studer'.$_GLOBALS['studer_count'].'id']=$dev+200;
                    if ($packet['value']==1) {
                        $_GLOBALS['studer'.$_GLOBALS['studer_count'].'family']="VT-65";
                    } else $_GLOBALS['studer'.$_GLOBALS['studer_count'].'family']="VT-80";
                     $_GLOBALS['studer_count']++;
                }
                if (filesize($s)) $st=fread($s,filesize($s));
               

     }
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/Studer.cgi?action=configure';
        $arr['title']='Studer';
        $arr['icon']='icon-hdd';
        $arr['desc']='Studer settings';
/*        $_GLOBALS['vars'][]='meter_frequency';
        $_GLOBALS['vars'][]='meter_voltage';
        $_GLOBALS['vars'][]='meter_current1';
        $_GLOBALS['vars'][]='meter_current2';
        $_GLOBALS['vars'][]='meter_current3';
        */
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        
        // generate ajax data for front end processing
        if (file_exists('/package/StuderAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/StuderAjax.inc';

        // runs this file once a second
        if (file_exists('/package/StuderSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/StuderSec.inc';
            
        // runs this file once a minute
//        if (file_exists('/package/EnergyMeterWidgetMin.inc')) 
//            $_GLOBALS['hooks']['min'][]='/package/EnergyMeterWidgetMin.inc';
            
        // runs this file once a day
//        if (file_exists('/package/EnergyMeterWidgetDay.inc')) 
//            $_GLOBALS['hooks']['sec'][]='/package/EnergyMeterWidgetDay.inc';            
        return 1;
    }
    
    function Studer_configure() {
         include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="TestWidget"; 
        $title='Configure Package TestWidget';
        $config_file="TestWidget.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Studer</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Studer Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget is a test widget.  Put your text here. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div ng-init='device_id="101";'></div>
<div ng-init='prop="6";'></div>
<div ng-init='val=0;'></div>
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Get Property</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="widget_test='<? print(ini_get("/config/".$config_file,$config_section,"test","")); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='device_id'>Device ID</label>
		            <div class="controls">
			            <input type='text' ng-model="device_id"  name='device_id' title="ID of device" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='prop'>Property Type</label>
		            <div class="controls">
			            <select ng-model="prop"  name='prop' title="Property Type" data-rel="tooltip">
			                <option value='1'>BOOL (1)</option>
			                <option value='2'>FORMAT (2)</option>
			                <option value='3'>ENUM (3)</option>
			                <option value='4'>ERROR (4)</option>
			                <option value='5'>INT32 (5)</option>
			                <option value='6'>FLOAT (6)</option>
			            </select>
			        </div>
		        </div>
                <div class="control-group">
		            <label class="control-label" for='object_id'>Object ID</label>
		            <div class="controls">
			            <input type='text' ng-model="object_id"  name='object_id' title="Object ID" data-rel="tooltip"> 
			        </div>
		        </div>		        
		        <div class="control-group" ng-show='val!=0'>
		            <label class="control-label" for='val'>Value</label>
		            <div class="controls">
			            <input type='text' ng-model="val"  name='val' title="Value" data-rel="tooltip"> 
			        </div>
		        </div>		        
		</fieldset>
		<button class="btn btn-primary btn-large pull-right" ng-click='getValue()'>Read Value</button>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function TestWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.getValue=function() {
       post_data="test="+$scope.widget_test;
       post_config="TestWidget.ini";
       post_section="config";
       $scope.val=0;
       $http.get('/package/Studer.cgi?action=ajax&device_id='+$scope.device_id+'&prop='+$scope.prop+"&object_id="+$scope.object_id)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Read value successful":"Error in communication";
          $scope.retval=data.val;
          $scope.val=data.val;
          $scope.retprop=data.prop;
          //alert(data.val);
          
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>


