<?
/**
 * @package LookupVar
 * @author Akash Heimlich
 * @description LookupVar

Sample LookupVar.ini

[config]
num_lookup=1
lookup_mask0="%m"
lookup_var0=pr_mul
val0_01=1.165
val0_02=1.120
val0_03=1.066
val0_04=1.016
val0_05=0.980
val0_06=0.968
val0_07=0.977
val0_08=0.987
val0_09=1.026
val0_10=1.100
val0_11=1.140
val0_12=1.167

 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    /*
group0var124vartype=3
group0var124varval=pr_mul
group0var124varscale=1
group0var124varfn=3
    */
    function log_global($global_var_name,$fn,$scale) {
        $num_d=ini_get("/config/datalog.ini","data","group0numvar",0);
        for ($j=0;$j<$num_d;$j++) {
            if ($global_var_name==ini_get("/config/datalog.ini","data","group0var".$j."varval",'')) {
                break;
            }
        }
        $id=$j;

        if ($id==$num_d)  {
                ini_set("/config/datalog.ini","data","group0numvar",$id+1);
                $f=fopen("/config/datalog.ini",'a+');
                $st="group0var"+$id+"varval=".$global_var_name."\r\n".
                    "group0var"+$id+"varfn=".$fn."\r\n".
                    "group0var"+$id+"varscale=".$scale."\r\n".
                    "group0var"+$id+"vartype=3\r\n";


                fwrite($f,$st);
                fclose($f);
                
        }
            
         
    }
    
    function LookupVar_install($val) {
        LookupVar_enable();
        return 1;
    }
     
    function LookupVar_uninstall() {
        setPackageStatus("LookupVar",0);
        return 1;
    }
    
    function LookupVar_enable() {
        setPackageStatus("LookupVar",2);
        addWidget("/package/LookupVar.inc","LookupVar",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function LookupVar_disable() {
        setPackageStatus("LookupVar",3);
        addWidget("/package/LookupVar.inc","LookupVar",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function LookupVar_init() {
        $_GLOBALS['num_lookup']=ini_get("/config/LookupVar.ini","config","num_lookup",0);
        for ($i=0;$i<$_GLOBALS['num_lookup'];$i++) {
            $_GLOBALS['lookup_mask'.$i]=ini_get("/config/LookupVar.ini","config","lookup_mask".$i,"%m");
            $_GLOBALS['lookup_var'.$i]=ini_get("/config/LookupVar.ini","config","lookup_var".$i,"lookup");
            
            $val=strftime($_GLOBALS['lookup_mask'].$i,time());
            $_GLOBALS[$_GLOBALS['lookup_var'].$i]=ini_get("/config/LookupVar.ini","config","val".$i."_".$val,0.0);
        }
        // load the test Value into the globals
        
    

        // generate ajax data for front end processing
        if (file_exists('/package/LookupVarAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/LookupVarAjax.inc';

        // runs this file once a minute
        if (file_exists('/package/LookupVarMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/LookupVarMin.inc';
            
        return 1;
    }
    
    function LookupVar_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="LookupVar"; 
        $title='Configure Package LookupVar';
        $config_file="LookupVar.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Test Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Test Widget Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget is a test widget.  Put your text here. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="widget_test='<? print(ini_get("/config/".$config_file,$config_section,"test","")); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='widget_test'>Test Value</label>
		            <div class="controls">
			            <input type='text' ng-model="widget_test"  name='widget_test' title="Enter a value to be saved to a config file for re-use later" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function LookupVar($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="test="+$scope.widget_test;
       post_config="LookupVar.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>


