<?
/**
 * @package Kaco Widget
 * @author Akash Heimlich
 * @description This widget communicates with Kaco inverters
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Kaco_install($val) {
        Kaco_enable();
        return 1;
    }
     
    function Kaco_uninstall() {
        setPackageStatus("Kaco",0);
        return 1;
    }
    
    function Kaco_enable() {
        setPackageStatus("Kaco",2);
        addWidget("/package/Kaco.inc","Kaco",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function Kaco_disable() {
        setPackageStatus("Kaco",3);
        addWidget("/package/Kaco.inc","Kaco",4,"icon-play",1,1); // disable
        return 1;
    }
    
function header_checksum($data,$start,$len) {
    $A = 0x84;
    $B = 0x08;
    for ($I = 0;$i<$len;$i++) {
        $A = ($A + $data[$start+$i]) % 0x100;
        $B = ($B + $A) % 0x100;
    }
    return ($A + $B<<8);
}



    function Kaco_ajax() {
    }
    $s=0;

    /* this is called at system boot */
    function Kaco_init() {
        global $s;
        $config_file='Kaco.ini';
        $config_section='config';
        //return 0;
        max_execution_time(120);
        $_GLOBALS['kaco']=array();
        $_GLOBALS['kaco_count']=0;
        $_GLOBALS['kaco_installed_count']=ini_get("/config/".$config_file,$config_section,"kaco_installed_count",1);
        $kaco_installed_count=$_GLOBALS['kaco_installed_count'];
        //print('hello '.$kaco_installed_count);
        //$s=fseropen(38400,0,0,1); // even parity
        $s=f485open(9600,0,0,0); // even parity
       // if (filesize($s)) $st=fread($s,filesize($s));
       print("<pre>");
        for ($i=1;$i<=$kaco_installed_count;$i++) {
             $data=fread($s,filesize($s));
             $a=array('#',sprintf("%02d",($i)),'0',13);
             print("Send: ");
             print_r($a);
            fwrite($s,$a);
            sleep(500);
            
            $num_dev=mb_num_devices();
            $found_index=-1;
            $found_id=-1;
            for ($j=0; $j < $num_dev; $j++) {
                $dev=mb_get_dev_by_index($j);
                if (($dev['slave_id']==$i) && ($dev['device_type_id']==8001)) {
                    $found_index=$i;
                    $found_id=$dev['slave_id'];
                    $_GLOBALS['inverter'.$i.'_idx']=$j;
                }
            }
            if ($found_index==-1) {
                $res=mb_add_dev($i,8001,"inverter".$i,1000,1,100);
                if (!$res) {
                } else {
                    log("Unable to add virtual device");
                }
            } else {
            }


            if (filesize($s)) {
                $data=fread($s,filesize($s));
                $_GLOBALS['inverter'.($_GLOBALS['kaco_count']++)."_id"]=$i;
                print(" response from ".$data);
                $rep_id=substr($data,2,3);
                $cmp='0'.$i.'n';
                print("REPLY:".$rep_id." ".$cmp);
                if ($rep_id==$cmp) {
                    print('good reply');
                    $checksum=substr($data,strlen($data)-5,4);
                    printf($checksum);
                    $res=array();
                    $val='';
                    for ($v=5;$v<strlen($data);$v++) {
                        $c=substr($data,$v,1);
                        if ($c==' ') {
                            if ($val!='') {
                                $res[]=$val;
                                $val='';
                                
                            }
                        } else $val.=$c;
                    }
                    //$res=explode($data,' ');
                    print("<pre>");
                    print_r($res);
                    $make=substr($res[1],strlen($res[1])-2,2);
                    $pwr=intval(substr($res[1],0,3));
                    print($make ." ".$pwr);
                    
                    $_GLOBALS['inverter'.$i.'_model']=$res[1];
                    /*if ($make=='TL' && $pwr<300) {
                        $_GLOBALS['inverter'.$i.'_mppt1_dc_v']=floatval($res[3]);
                        $_GLOBALS['inverter'.$i.'_mppt1_dc_a']=floatval($res[4]);
                        $_GLOBALS['inverter'.$i.'_mppt1_dc_w']=floatval($res[5]);
                        $_GLOBALS['inverter'.$i.'_mppt2_dc_v']=floatval($res[6]);
                        $_GLOBALS['inverter'.$i.'_mppt2_dc_a']=floatval($res[7]);
                        $_GLOBALS['inverter'.$i.'_mppt2_dc_w']=floatval($res[8]);
                        $_GLOBALS['inverter'.$i.'_ac1_v']=floatval($res[9]);
                        $_GLOBALS['inverter'.$i.'_ac1_a']=floatval($res[10]);
                        $_GLOBALS['inverter'.$i.'_ac2_v']=floatval($res[11]);
                        $_GLOBALS['inverter'.$i.'_ac2_a']=floatval($res[12]);
                        $_GLOBALS['inverter'.$i.'_ac3_v']=floatval($res[13]);
                        $_GLOBALS['inverter'.$i.'_ac3_a']=floatval($res[14]);
                        $_GLOBALS['inverter'.$i.'_dc_w']=floatval($res[15]);
                        $_GLOBALS['inverter'.$i.'_ac_w']=floatval($res[16]);
                        $_GLOBALS['inverter'.$i.'_cosphi']=floatval($res[17]);
                        $_GLOBALS['inverter'.$i.'_temp']=floatval($res[18]);
                        $_GLOBALS['inverter'.$i.'kwh_today']=floatval($res[19]);
                    }*/

                    
                }
            } else {
                  print("No response from ".$id);
            }
        }
        
     
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/Kaco.cgi?action=configure';
        $arr['title']='Kaco';
        $arr['icon']='icon-hdd';
        $arr['desc']='Kaco settings';
/*        $_GLOBALS['vars'][]='meter_frequency';
        $_GLOBALS['vars'][]='meter_voltage';
        $_GLOBALS['vars'][]='meter_current1';
        $_GLOBALS['vars'][]='meter_current2';
        $_GLOBALS['vars'][]='meter_current3';
        */
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        
        // generate ajax data for front end processing
        if (file_exists('/package/KacoAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/KacoAjax.inc';

        // runs this file once a second
        if (file_exists('/package/KacoSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/KacoSec.inc';
            
        // runs this file once a minute
//        if (file_exists('/package/EnergyMeterWidgetMin.inc')) 
//            $_GLOBALS['hooks']['min'][]='/package/EnergyMeterWidgetMin.inc';
            
        // runs this file once a day
//        if (file_exists('/package/EnergyMeterWidgetDay.inc')) 
//            $_GLOBALS['hooks']['sec'][]='/package/EnergyMeterWidgetDay.inc';            
        return 1;
    }
    
    function Kaco_configure() {
          include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="TestWidget"; 
        $title='Configure Package Kaco';
        $config_file="Kaco.ini";
        $config_section="config";
        $num_inverters=$_GLOBALS['kaco_count']?$_GLOBALS['kaco_count']:1;
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Kaco</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Kaco Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
Delta RPI inverters are automatically detected at boot up. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="kaco_installed_count=<? print(ini_get("/config/".$config_file,$config_section,"kaco_installed_count",1)); ?>;">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='kaco_installed_count'>Num Installed Inverters</label>
		            <div class="controls">
			            <input type='number' ng-model="kaco_installed_count"  name='kaco_installed_count' title="Enter the number of inverters installed" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<? for ($i=0;$i<$num_inverters;$i++) { ?>
		<div ng-init="kaco<? print ($i); ?>_kwh_offset=<? print(ini_get("/config/".$config_file,$config_section,"kaco"+$i+"_kwh_offset",0)); ?>;">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='kaco<? print ($i); ?>_kwh_offset'><? print("Inverter ".($i+1)." kWh Offset"); ?></label>
		            <div class="controls">
			            <input type='number' ng-model="kaco<? print ($i); ?>_kwh_offset"  name='kaco<? print ($i); ?>_kwh_offset' title="Enter a kwh reading offset if required" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<? } ?>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function TestWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data=<?
        for ($i=0;$i<$num_inverters;$i++) {
            if ($i) print("&");
            print('"kaco'.$i.'_kwh_offset="+$scope.kaco'+$i+'_kwh_offset');
        }
        ?>;
        post_data+="&kaco_installed_count="+$scope.kaco_installed_count;
       post_config="Kaco.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
</div>   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>






